% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/relationships.R
\name{extract_relations}
\alias{extract_relations}
\title{Extract all \verb{<relation>} tags from a TWB}
\usage{
extract_relations(xml_doc)
}
\arguments{
\item{xml_doc}{An \code{xml2} document for a Tableau \code{.twb}.}
}
\value{
A tibble with columns:
\item{name}{Relation name}
\item{table}{Table reference}
\item{connection}{Connection ID}
\item{type}{Relation type (table, join, etc.)}
\item{join}{Join type if applicable}
\item{custom_sql}{Inline SQL text if present}
}
\description{
Returns a tibble of \verb{<relation>} elements found in a Tableau TWB XML,
with key attributes and any custom SQL text.
}
\examples{
twb <- system.file("extdata", "test_for_wenjie.twb", package = "twbparser")
stopifnot(nzchar(twb), file.exists(twb))
xml <- xml2::read_xml(twb)
fields <- extract_columns_with_table_source(xml)
inferred <- infer_implicit_relationships(fields)
head(inferred)


}
