% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculated_fields.R
\name{extract_raw_fields}
\alias{extract_raw_fields}
\title{Extract non-calculated, non-parameter fields from a TWB}
\usage{
extract_raw_fields(xml_doc)
}
\arguments{
\item{xml_doc}{An \code{xml2} document for a Tableau \code{.twb}.}
}
\value{
A tibble with columns:
\describe{
\item{datasource}{Datasource name.}
\item{name}{User-visible caption or cleaned internal name.}
\item{tableau_internal_name}{Internal Tableau name.}
\item{datatype}{Tableau datatype.}
\item{role}{Tableau role.}
\item{is_hidden}{Whether the field is hidden.}
\item{is_parameter}{Always \code{FALSE}.}
\item{table}{Raw table reference.}
\item{table_clean}{Cleaned table name.}
}
}
\description{
Returns raw columns excluding calculated fields and parameters.
}
\examples{
twb <- system.file("extdata", "test_for_wenjie.twb", package = "twbparser")
stopifnot(nzchar(twb), file.exists(twb))
xml <- xml2::read_xml(twb)
raw_fields <- extract_raw_fields(xml)
head(raw_fields)


}
