% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_pretty_call_stack.R
\name{get.pretty.call.stack}
\alias{get.pretty.call.stack}
\title{Pretty formatted call stack enriched with the source file names and row numbers}
\usage{
get.pretty.call.stack(call.stack, omit.last.items = 0, compact = FALSE)
}
\arguments{
\item{call.stack}{Call stack object created by \code{\link{sys.calls}}}

\item{omit.last.items}{Number of call stack items to drop from the end of the full stack trace}

\item{compact}{TRUE will return only call stack items that have a source code reference (FALSE all)}
}
\value{
The call stack (\code{\link{sys.calls}}) without the last number of function calls (given by "omit.last.items")
         to remove irrelevant calls caused e. g. by exception handler (\code{\link{withCallingHandlers}})
         or restarts (of warnings).
}
\description{
Enriches the current call stack with the source file names and row numbers
             to track the location of thrown conditions and generates a prettily formatted list
             of strings
}
\details{
How to read the call stack:
         \enumerate{
         \item Call stack items consist of:\cr
            \code{<call stack item number> [<file name>#<row number>:] <expression executed by this code line>}
         \item The last call stack items with a file name and row number points to the source code line causing the error.
         \item Ignore all call stack items that do not start with a file name and row number (R internal calls only)
         }
         You should only call this function from within \code{\link{withCallingHandlers}}, NOT from within \code{\link{tryCatch}}
         since tryCatch unwinds the call stack to the tryCatch position and the source of the condition cannot be identified anymore.
}
\seealso{
\code{\link{tryCatchLog}}, \code{\link{tryLog}}, \code{\link{limitedLabelsCompact}}
}
