% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{toscca.folds}
\alias{toscca.folds}
\title{Sparse Canonical Correlation Analysis. Computation of CC via NIPALS with soft thresholding.}
\usage{
toscca.folds(
  A,
  B,
  nonzero_a,
  nonzero_b,
  alpha_init,
  folds = 1,
  parallel_logic = FALSE,
  silent = FALSE,
  toPlot = TRUE,
  ATest_res = NULL,
  BTest_res = NULL
)
}
\arguments{
\item{A, B}{Data matrices.}

\item{nonzero_a, nonzero_b}{Numeric. Scalar or vector over the number of nonzeroes allowed for a correlation estimate.}

\item{alpha_init}{Character. Type initialisation for \deqn{\mathbf{\alpha}}. Default is "eigen".}

\item{folds}{Integer. Indicates number of folds to perform.}

\item{parallel_logic}{Logical. TRUE to parallelise folds. Default is FALSE.}

\item{silent}{Logical. TRUE to keep silent output messages. Default is FALSE.}

\item{toPlot}{Logical. TRUE to plot results.}

\item{ATest_res}{NULL. Keep NULL.}

\item{BTest_res}{NULL. Keep NULL.}
}
\value{
a list with the following elements:
}
\description{
Sparse Canonical Correlation Analysis. Computation of CC via NIPALS with soft thresholding.
}
