% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/basic.R
\name{plt.selstab}
\alias{plt.selstab}
\title{Plot slection stability for penalty parameter performance.}
\usage{
plt.selstab(
  object,
  X,
  Y,
  nonz_x,
  nonz_y,
  palette_values = mpalette,
  blue = TRUE,
  mm = TRUE,
  k = 1
)
}
\arguments{
\item{object}{A toscca object.}

\item{X}{nxp matrix. Observation matrix.}

\item{Y}{A nxq matrix. Observation matrix.}

\item{nonz_x}{Numeric vector. Sparsity levels of X.}

\item{nonz_y}{Numeric vector. Sparsity levels of Y.}

\item{palette_values}{Character. Name of a palette for the heatmap. Default is "Teal".}

\item{blue}{Logical. If TRUE, use only scale of blues from palette.}

\item{mm}{Logic. Indicates whether there are multiple measurements or not. Default is True.}

\item{k}{Numeric. Component, default k =1.}
}
\value{
No return value, called for selection stability pot.
}
\description{
This function plots cv for different thresholds
}
\examples{
\donttest{
# example code
#sample size etc
N = 10
p = 25
q = 5
# noise
X0 = sapply(1:p, function(x) rnorm(N))
Y0 = sapply(1:q, function(x) rnorm(N))

colnames(X0) = paste0("x", 1:p)
colnames(Y0) = paste0("y", 1:q)

# signal
Z1 = rnorm(N,0,10)


#Some associations with the true signal
alpha = (6:10) / 10
beta  = -(2:3) / 10

loc_alpha = 1:length(alpha)
loc_beta  = 1:length(beta)

for(j in 1:length(alpha))
  X0[, loc_alpha[j]] =  alpha[j] * Z1 + rnorm(N,0,0.03)

for(j in 1:length(beta))
  Y0[, loc_beta[j]] =  beta[j] * Z1 + rnorm(N,0,0.03)

# performa toscca
X = standardVar(X0)
Y = standardVar(Y0)
K = 2                                       # number of components to be estimated
nonz_x = c(2,5, 10, 20)                     # number of nonzero variables for X
nonz_y = c(2, 3, 4)                      # number of nonzero variables for Y
init   = "uniform"                          # type of initialisation
cca_toscca  = toscca(X, Y, nonz_x, nonz_y, K, alpha_init = init,
combination = TRUE, K=1, silent = TRUE, toPlot = FALSE)
plt <- plt.selstab(cca_toscca,X, Y, nonz_x = nonz_x, nonz_y = nonz_y, mm=FALSE)
}
}
