% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transforms-generics.R
\name{transform_linear_transformation}
\alias{transform_linear_transformation}
\title{Transform a tensor image with a square transformation matrix and a
mean_vector computed offline}
\usage{
transform_linear_transformation(img, transformation_matrix, mean_vector)
}
\arguments{
\item{img}{A \code{magick-image}, \code{array} or \code{torch_tensor}.}

\item{transformation_matrix}{(Tensor): tensor \verb{[D x D]}, D = C x H x W.}

\item{mean_vector}{(Tensor): tensor \link{D}, D = C x H x W.}
}
\description{
Given \code{transformation_matrix} and \code{mean_vector}, will flatten the
\code{torch_tensor} and subtract \code{mean_vector} from it which is then followed by
computing the dot product with the transformation matrix and then reshaping
the tensor to its original shape.
}
\section{Applications}{

whitening transformation: Suppose X is a column vector zero-centered data.
Then compute the data covariance matrix \verb{[D x D]} with torch.mm(X.t(), X),
perform SVD on this matrix and pass it as \code{transformation_matrix}.
}

\seealso{
Other unitary_transforms: 
\code{\link{transform_adjust_brightness}()},
\code{\link{transform_adjust_contrast}()},
\code{\link{transform_adjust_gamma}()},
\code{\link{transform_adjust_hue}()},
\code{\link{transform_adjust_saturation}()},
\code{\link{transform_affine}()},
\code{\link{transform_center_crop}()},
\code{\link{transform_convert_image_dtype}()},
\code{\link{transform_crop}()},
\code{\link{transform_grayscale}()},
\code{\link{transform_hflip}()},
\code{\link{transform_normalize}()},
\code{\link{transform_pad}()},
\code{\link{transform_perspective}()},
\code{\link{transform_resize}()},
\code{\link{transform_rgb_to_grayscale}()},
\code{\link{transform_rotate}()},
\code{\link{transform_to_tensor}()},
\code{\link{transform_vflip}()}
}
\concept{unitary_transforms}
