% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gen-namespace-docs.R,
%   R/gen-namespace-examples.R, R/gen-namespace.R
\name{torch_as_strided}
\alias{torch_as_strided}
\title{As_strided}
\usage{
torch_as_strided(self, size, stride, storage_offset = NULL)
}
\arguments{
\item{self}{(Tensor) the input tensor.}

\item{size}{(tuple or ints) the shape of the output tensor}

\item{stride}{(tuple or ints) the stride of the output tensor}

\item{storage_offset}{(int, optional) the offset in the underlying storage of the output tensor}
}
\description{
As_strided
}
\section{as_strided(input, size, stride, storage_offset=0) -> Tensor }{


Create a view of an existing \code{torch_Tensor} \code{input} with specified
\code{size}, \code{stride} and \code{storage_offset}.
}

\section{Warning}{

More than one element of a created tensor may refer to a single memory
location. As a result, in-place operations (especially ones that are
vectorized) may result in incorrect behavior. If you need to write to
the tensors, please clone them first.

\if{html}{\out{<div class="sourceCode">}}\preformatted{Many PyTorch functions, which return a view of a tensor, are internally
implemented with this function. Those functions, like
`torch_Tensor.expand`, are easier to read and are therefore more
advisable to use.
}\if{html}{\out{</div>}}
}

\examples{
if (torch_is_installed()) {

x = torch_randn(c(3, 3))
x
t = torch_as_strided(x, list(2, 2), list(1, 2))
t
t = torch_as_strided(x, list(2, 2), list(1, 2), 1)
t
}
}
