% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tfrmt_layer.R
\name{update_group}
\alias{update_group}
\title{Remap group values in a tfrmt}
\usage{
update_group(tfrmt, ...)
}
\arguments{
\item{tfrmt}{a \code{tfrmt}}

\item{...}{Use new_name = old_name to rename selected variables}
}
\value{
A \code{tfrmt} with the \code{group} variables updated in all places

tfrmt object with updated groups#'
}
\description{
Remap group values in a tfrmt
}
\examples{

tfrmt_spec <- tfrmt(
    group = c(group1, group2),
    body_plan  = body_plan(
      frmt_structure(
         group_val = list(group2 = "value"),
         label_val = ".default",
         frmt("XXX")
         ),
     frmt_structure(
         group_val = list(group1 = "value", group2 = "value"),
         label_val = ".default",
         frmt("XXX")
       )
    ))

tfrmt_spec \%>\%
  update_group(New_Group = group1)

}
