% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lagpol.R
\name{polyderivEvalR}
\alias{polyderivEvalR}
\title{Evaluate the k-th derivative of a polynomial at point z}
\usage{
polyderivEvalR(pol, z, k = 0)
}
\arguments{
\item{pol}{Numeric vector of polynomial coefficients in ascending order
(pol[1] = constant term, pol[2] = coefficient of z, etc.)}

\item{z}{Numeric value where the polynomial (or its derivative) is evaluated.}

\item{k}{Integer. Derivative order (0 = original polynomial).}
}
\value{
Numeric value of the k-th derivative of P(z).
}
\description{
Evaluate the k-th derivative of a polynomial at point z
}
\examples{
pol <- c(1, 2, 3, 4)  # P(z) = 1 + 2z + 3z² + 4z³
polyderivEvalR(pol, 2, 0)  # 49
polyderivEvalR(pol, 2, 1)  # 62
}
