% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sheet2xml.R
\name{sheet2xml}
\alias{sheet2xml}
\title{Convert a Spreadsheet to XML}
\usage{
sheet2xml(file_path, template_path, xml_path = NULL, optimize = FALSE)
}
\arguments{
\item{file_path}{Character. Path to the spreadsheet file to be converted.
Supports Excel (.xlsx) and ODS formats.}

\item{template_path}{Character. Path to the XML template file to guide the
transformation process.}

\item{xml_path}{Character (optional). Output path for the generated XML file.
If NULL, it is considered an XML file with the same name and location as the
spreadsheet file.}

\item{optimize}{Boolean. Remove empty nodes from the xml file.}
}
\value{
Character. The file path of the generated XML document.
}
\description{
It reads a spreadsheet file (Excel or ODS), processes it using a provided XML
template, and generates an XML output file.
}
\examples{
source_xml <- system.file("extdata", "schema_template.xml", package = "tab2xml")

source_xlsx <- system.file("extdata", "schema.xlsx", package = "tab2xml")
temp_file1 <- tempfile(fileext = ".xml")
sheet2xml(source_xlsx, source_xml, temp_file1)

source_ods <- system.file("extdata", "schema.ods", package = "tab2xml")
temp_file2 <- tempfile(fileext = ".xml")
sheet2xml(source_ods, source_xml, temp_file2)

}
