% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stratEst_simulate.R
\name{stratEst.simulate}
\alias{stratEst.simulate}
\title{Simulation function for strategy estimation.}
\usage{
stratEst.simulate(
  data = NULL,
  strategies,
  shares = NULL,
  coefficients = NULL,
  covariate.mat = NULL,
  num.ids = 100,
  num.games = 5,
  num.periods = NULL,
  fixed.assignment = TRUE,
  input.na = FALSE,
  sample.id = NULL
)
}
\arguments{
\item{data}{a \code{stratEst.data} object. Alternatively, the arguments \code{num.ids}, \code{num.games}, and \code{num.periods} can be used if no data is available.}

\item{strategies}{a list of strategies. Each element if the list must be an object of class \code{stratEst.strategy}.}

\item{shares}{a numeric vector of strategy shares. The order of the elements corresponds to the order in \code{strategies}. \code{NA} values are not allowed. Use a list of numeric vectors if data has more than one sample and shares are sample specific.}

\item{coefficients}{a matrix of regression coefficients. Column names correspond to the names of the strategies, row names to the names of the covariates.}

\item{covariate.mat}{a matrix with the covariates in columns. The column names of the matrix indicate the names of the covariates. The matrix must have as many rows as there are individuals.}

\item{num.ids}{an integer. The number of individuals. Default is 100.}

\item{num.games}{an integer. The number of games. Default is 5.}

\item{num.periods}{a vector of integers with as many elements \code{num.games}. The elements specify the number of periods in each game. Default (\code{NULL}) means 5 periods in each game.}

\item{fixed.assignment}{a logical value. If \code{FALSE} individuals use potentially different strategies in each each game. If \code{TRUE}, individuals use the same strategy in each game. Default is \code{FALSE}.}

\item{input.na}{a logical value. If \code{FALSE} an input value is randomly selected for the first period. Default is \code{FALSE}.}

\item{sample.id}{a character string indicating the name of the variable which identifies the samples in data. Individual observations must be nested in samples. Default is \code{NULL}.}
}
\value{
A \code{stratEst.data} object. A data frame in the long format with the following variables:
\item{id}{the variable that identifies observations of the same individual.}
\item{game}{the variable that identifies observations of the same game.}
\item{period}{the period of the game.}
\item{choice}{the discrete choices.}
\item{input}{the inputs.}
\item{sample}{the sample of the individual.}
\item{strategy}{the strategy of the individual.}
}
\description{
The simulation function of the package.
}
\examples{
## Simulate data of two strategies for choices "left" and "right".
lr <- c("left","right")
pi <- runif(1)
pr <- c(1,0,0,1)
tr <- c(1,2,1,2)
mixed <- stratEst.strategy(choices = lr, inputs = lr, prob.choices = c(pi, 1 - pi))
pure <- stratEst.strategy(choices = lr, inputs = lr, prob.choices = pr, tr.inputs = tr)
gamma <- runif(1)/4
pure$tremble <- gamma
beta <- rnorm(1)
p <- 1/sum(1 + exp(beta))
sim.shares <- c(p, 1-p)
sim.strategies <- list("mixed" = mixed, "pure" = pure)
sim.data <- stratEst.simulate(strategies = sim.strategies, shares = sim.shares)

}
