% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/outliermethods.R
\name{semiIQR}
\alias{semiIQR}
\title{Computes semi-interquantile range to flag suspicious outliers}
\usage{
semiIQR(data, var, output, x = 3, pc = FALSE, pcvar = NULL, boot = FALSE)
}
\arguments{
\item{data}{Dataframe to check for outliers}

\item{var}{Environmental parameter considered in flagging suspicious outliers}

\item{output}{Either clean: for dataframe with no suspicious outliers or outlier: to retrun dataframe with only outliers}

\item{x}{A constant to create a fence or boundary to detect outliers.}

\item{pc}{Whether principal component analysis will be computed. Default \code{FALSE}}

\item{pcvar}{Principal component analysis to e used for outlier detection after PCA. Default \code{PC1}}

\item{boot}{Whether bootstrapping will be computed. Default \code{FALSE}}
}
\value{
Dataframe with or with no outliers.
}
\description{
Computes semi-interquantile range to flag suspicious outliers
}
\details{
SemiInterquantile Ranges introduced adjusts for whiskers on either
side to flag suspicious outliers [Q1 – 3(Q2 (median) - Q1); Q3 + 3(Q3 - Q2)] \code{((Kimber 1990))}.
However, SIQR introduced the same constant values for bounding fences
for the lower and upper quartiles \code{(Rousseeuw & Hubert 2011)}, which leads to
outlier swamping and masking.
}
\examples{
\donttest{

data("efidata")

danube <- system.file('extdata/danube.shp.zip', package='specleanr')

db <- sf::st_read(danube, quiet=TRUE)

wcd <- terra::rast(system.file('extdata/worldclim.tiff', package='specleanr'))

refdata <- pred_extract(data = efidata, raster= wcd ,
                          lat = 'decimalLatitude', lon= 'decimalLongitude',
                          colsp = "scientificName",
                          bbox = db,
                          minpts = 10)

 semiout <- semiIQR(data = refdata[["Thymallus thymallus"]], var = 'bio6', output='outlier')
}

}
\references{
Kimber AC. 1990. Exploratory Data Analysis for Possibly Censored Data From Skewed Distributions.
Page Source: Journal of the Royal Statistical Society. Series C (Applied Statistics).
}
