% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/z_normalization.R
\name{z_normalization}
\alias{z_normalization}
\title{z normalization}
\usage{
z_normalization(
  x,
  method = c("original", "modified"),
  na = c("keep", "remove")
)
}
\arguments{
\item{x}{Timeseries vector to normalize}

\item{method}{("original", "modified") Use the standard z normalization or modified version}

\item{na}{Behavior of NA values, keep or remove}
}
\value{
vector of z normalized data
}
\description{
Z-normalizes a time series by subtracting its mean and dividing by the standard deviation or meadian and MAD
}
\note{
The original method is to subtract x rom the mean then divide by sd whereas, modified uses the median and mad. 
For NA's if the argument is keep, an NA index is built and the NA's are re-inserted in to the resulting vector.
The behavior of remove will entirely remove them and result in a vector length different than the input.
}
\examples{
 # add data
 data(EuStockMarkets)
 d <- as.vector(EuStockMarkets[,1])

# Calculate Z score
summary(d)
summary(Z_org <- z_normalization(d) ) 
summary(Z_mod <- z_normalization(d, method="modified") )
  par(mfrow=c(3,1))
    plot(density(d), main="original timeseries")
    plot(density(Z_org), main="original z norm")
    plot(density(Z_mod), main="modified z norm")

# Check NA behavior, insert some NA's
d[c(100, 500, 1000, 1400)] <- NA
length(d)
length( z_normalization(d, na="keep") ) 
length( z_normalization(d, na="remove") ) 
 
}
\references{
Iglewicz, B. & D.C. Hoaglin (1993) How to Detect and Handle Outliers, 
  American Society for Quality Control, Milwaukee, WI.
}
\author{
Jeffrey S. Evans  <jeffrey_evans@tnc.org>
}
