% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dissection.R
\name{dissection}
\alias{dissection}
\title{Dissection}
\usage{
dissection(x, s = 5, ...)
}
\arguments{
\item{x}{A terra SpatRaster class object}

\item{s}{Focal window size}

\item{...}{Additional arguments passed to terra::lapp}
}
\value{
A SpatRaster class object of Martonne's modified dissection
}
\description{
Calculates the Evans (1972) Martonne's modified 
             dissection
}
\details{
Dissection is calculated as: 
( z(s) - min(z(s)) ) / ( max(z(s)) - min(z(s)) )
}
\examples{
\donttest{ 
library(terra)
elev <- rast(system.file("extdata/elev.tif", package="spatialEco"))
  d <- dissection(elev, s=3)
    plot(d, main="dissection") 
}     

}
\author{
Jeffrey S. Evans  <jeffrey_evans@tnc.org>
}
