% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{deriv_qn}
\alias{deriv_qn}
\title{Analytic D matrix for Quantization Noise (QN) Process}
\usage{
deriv_qn(tau)
}
\arguments{
\item{tau}{A \code{vec} containing the scales e.g. \eqn{2^{\tau}}{2^tau}}
}
\value{
A \code{matrix} with the first column containing 
the partial derivative with respect to \eqn{Q^2}{Q^2}.
}
\description{
Obtain the first derivative of the Quantization Noise (QN) process.
}
\section{Process Haar WV First Derivative}{

Taking the derivative with respect to \eqn{Q^2}{Q^2} yields:
\deqn{\frac{\partial }{{\partial {Q^2}}}\nu _j^2\left( {{Q^2}} \right) = \frac{6}{{\tau _j^2}}}{d/dQ2 nu[j]^2 (Q2) = (6) / (tau[j]^2)}
}

\author{
James Joseph Balamuta (JJB)
}
