% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ts.model.R
\name{ARMA11}
\alias{ARMA11}
\title{Definition of an ARMA(1,1)}
\usage{
ARMA11(phi = NULL, theta = NULL, sigma2 = 1)
}
\arguments{
\item{phi}{A \code{double} containing the parameter \eqn{\phi _1}{phi[1]} (see Note for details).}

\item{theta}{A \code{double} containing the parameter \eqn{\theta _1}{theta[1]} (see Note for details).}

\item{sigma2}{A \code{double} value for the parameter \eqn{\sigma^2}{sigma^2} (see Note for details).}
}
\value{
An S3 object with called ts.model with the following structure:
\describe{
 \item{process.desc}{\eqn{AR1}, \eqn{MA1}, \eqn{SIGMA2}}
 \item{theta}{\eqn{\phi}{phi}, \eqn{\theta}{theta}, \eqn{\sigma^2}{sigma^2}}
 \item{plength}{Number of Parameters: 3}
 \item{print}{String containing simplified model}
 \item{obj.desc}{Depth of Parameters e.g. list(c(1,1,1))}
 \item{starting}{Guess Starting values? \code{TRUE} or \code{FALSE} (e.g. specified value)}
}
}
\description{
Definition of an ARMA(1,1)
}
\details{
A variance is required since the model generation statements utilize 
randomization functions expecting a variance instead of a standard deviation like R.
}
\note{
We consider the following model: \deqn{X_t = \phi X_{t-1} + \theta_1 \varepsilon_{t-1} + \varepsilon_t,} where \eqn{\varepsilon_t} is iid from a zero 
mean normal distribution with variance \eqn{\sigma^2}.
}
\examples{
# Creates an ARMA(1,1) process with predefined coefficients.
ARMA11(phi = .23, theta = .1, sigma2 = 1)

# Creates an ARMA(1,1) process with values to be guessed on callibration.
ARMA11()
}
\author{
James Balamuta
}
