% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict-height.R
\name{eq_hd_vazquez_veloso_2025}
\alias{eq_hd_vazquez_veloso_2025}
\title{Estimates tree height from DBH}
\usage{
eq_hd_vazquez_veloso_2025(
  species,
  bioregion = "mediterranean",
  origin = "natural",
  mixture = "pure"
)
}
\arguments{
\item{species}{A character string specifying the scientific name of the tree
species. It can be a column name if all the species are included in this model.
See Details for available species. If not specified, it takes the value "All the species", which corresponds
to a generic model applicable to all species.}

\item{bioregion}{The biogeopgrahic region of the species. Available options are:
\code{mediterranean}, \code{atlantic}, \code{alpine}, and \code{macaronesian}. If not specified,
it takes the value \code{mediterranean}, which is the most common region in Spain. You can check the
distribution of regions here: https://ars.els-cdn.com/content/image/1-s2.0-S037811272500489X-gr1.jpg}

\item{origin}{The origin of the stand. Available options are: \code{natural} and
\code{plantation}. If not specified, it takes the value \code{natural}, which is the most common origin in Spain.}

\item{mixture}{The species available in the stand. Available options are: \code{pure} and
\code{mix}. Consider the characteristics of the plot you are evaluating and not the entire forest, as the
conditions of each stand are different. In this study, it was considered a stand to be mixed when the combined
proportion of at least two species exceeds 90\% of the plot's basal area, and the proportion of both species is
greater than 15\% of the total. It does not matter which species is accompanying or the proportion of mixing.
If not specified, it takes the value \code{pure}, which is the most common condition in Spain.}
}
\value{
A numeric vector with predicted height
}
\description{
This function is intended to be used in \code{\link[=silv_predict_height]{silv_predict_height()}}. It implements the h-d equations
developed in Vázquez-Veloso et al. (2025). These equations have been developed using the Spanish
National Forest Inventory, and therefore, they should only be applied within Spain. The model includes
parameters for 91 tree species.
}
\details{
Details...#TODO
}
\examples{
1 + 1 #TODO
}
\references{
Vázquez-Veloso, A., Yang, S.-I., Bullock, B.P., Bravo, F., 2025. One model to rule them all:
A nationwide height–diameter model for 91 Spanish forest species. Forest Ecology and Management 595, 122981.
https://doi.org/10.1016/j.foreco.2025.122981
}
\seealso{
\code{\link[=silv_predict_height]{silv_predict_height()}}
}
