% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sensitivityIxJ.R
\name{sampling.score.sen.IxJ}
\alias{sampling.score.sen.IxJ}
\title{Monte Carlo Score Test Sensitivity Analysis for I by J Tables}
\usage{
sampling.score.sen.IxJ(
  obs.table,
  gamma,
  delta,
  row = "treatment",
  mc.iteration = 5000,
  treatment.scores,
  outcome.scores,
  verbose = FALSE
)
}
\arguments{
\item{obs.table}{A matrix or table object representing the observed contingency table.}

\item{gamma}{a nonnegative scalar}

\item{delta}{A binary vector with no more than two unique values,
corresponding to treatment levels. The length must match the number of
treatments. Must have a monotone trend for ordinal tests.}

\item{row}{A string indicating whether rows represent "outcome" or "treatment".
Must be either "outcome" or "treatment". Default is "treatment".}

\item{mc.iteration}{Integer specifying the number of Monte Carlo iterations
for each u-allocation. Higher values increase accuracy but require more
computation time. Default is 5000.}

\item{treatment.scores}{A numeric vector specifying scores for each treatment
level. Must have the same length as the number of treatments and exhibit
a monotone trend.}

\item{outcome.scores}{A numeric vector specifying scores for each outcome level.
Must have the same length as the number of outcomes and exhibit a monotone trend.}

\item{verbose}{Logical flag indicating whether to print progress messages
during computation. Default is FALSE.}
}
\value{
A list containing:
\item{rct.prob}{Estimated probability under RCT (all u-allocations zero)}
\item{max.prob}{Maximum estimated probability across all u-allocations}
\item{maximizer}{The u-allocation vector yielding max.prob}
\item{obs.stat}{Observed test statistic value}
\item{obs.table}{The input observed table}
\item{gamma}{Extracted gamma value from the generic bias model}
\item{delta}{delta vector}
}
\description{
This function implements a sampling-based approach to sensitivity analysis for
score tests in I by J contingency tables under the generic bias model. It uses
Sequential Importance Sampling (SIS) from Eisinger and Chen (2017) to approximate
p-values when exact computation is infeasible due to large reference set
}
\details{
The function uses importance sampling to estimate p-values for score tests
when both treatments and outcomes are ordinal. The score test statistic is
computed as the sum of products of cell counts with their corresponding
treatment and outcome scores.

The u-space is automatically constructed to respect the ordinal nature of
the data, focusing on allocations that assign bias to higher outcome levels
first (assuming an increasing trend in outcome scores).

Unlike exact methods, this function provides Monte Carlo estimates that
converge to true values as mc.iteration increases. Results may vary
slightly between runs unless the random seed is fixed.
}
\examples{
\donttest{
# Binary outcome example
obs.table <- matrix(c(15, 10, 5, 20), ncol = 2, byrow = TRUE)
result <- sampling.score.sen.IxJ(obs.table = obs.table,
                                 gamma = 0.5,
                                 delta = c(0, 1),
                                 treatment.scores = c(0, 1),
                                 outcome.scores = c(0, 1),
                                 mc.iteration = 5000)
}

}
\references{
Eisinger, R. D., & Chen, Y. (2017). Sampling for Conditional Inference on
Contingency Tables. Journal of Computational and Graphical Statistics, 26(1),
79–87.
}
\seealso{
\code{\link{exact.score.sen.IxJ}} for exact computation when feasible,
\code{\link{sampling.general.sen.IxJ}} for general test statistics.
}
