% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PGN_RF.R
\name{PGN_RF}
\alias{PGN_RF}
\title{Peak-Gene Network via Random Forest}
\usage{
PGN_RF(
  X,
  Y,
  gene_data,
  neibor_peak,
  dirpath = tempdir(),
  count_device = 1,
  rebuild_PGN_RF = TRUE,
  save_file = TRUE,
  seed = NULL,
  python_env = "scPOEM_env"
)
}
\arguments{
\item{X}{The scATAC-seq data, sparse matrix.}

\item{Y}{The scRNA-seq data, sparse matrix.}

\item{gene_data}{The information for genes, must have a col names "gene_name".}

\item{neibor_peak}{The peak IDs within a certain range of each gene, must have cols c("gene_name", "start_use", "end_use"). The id numbers in "start_use" and "end_use" are start from 0.}

\item{dirpath}{The folder path to read or write file.}

\item{count_device}{The number of cpus used to train the Lasso model.}

\item{rebuild_PGN_RF}{Logical. Whether to rebuild the peak-gene network via random forest from scratch. If FALSE, the function will attempt to read from \code{PGN_RF.mtx} under \code{dirpath/test} in single mode or \code{dirpath/state_name/test} in compare mode.}

\item{save_file}{Logical, whether to save the output to a file.}

\item{seed}{An integer specifying the random seed to ensure reproducible results.}

\item{python_env}{Name or path of the Python environment to be used.}
}
\value{
The PGN_RF network.
}
\description{
Construct the peak-gene network via random forest.
}
\examples{
\donttest{
library(scPOEM)
dirpath <- "./example_data"
# Download single mode example data
data(example_data_single)
# Construct PGN net via random forest (RF).
net_RF <- PGN_RF(example_data_single$X,
                 example_data_single$Y,
                 example_data_single$gene_data,
                 example_data_single$neibor_peak,
                 file.path(dirpath, "single"),
                 save_file=FALSE)
}

}
