% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GMST.R
\name{GMST}
\alias{GMST}
\title{Compute the Global Mean Surface Temperature (GMST) anomalies}
\usage{
GMST(
  data_tas,
  data_tos,
  data_lats,
  data_lons,
  mask_sea_land,
  sea_value,
  type,
  mask = NULL,
  lat_dim = "lat",
  lon_dim = "lon",
  monini = 11,
  fmonth_dim = "fmonth",
  sdate_dim = "sdate",
  indices_for_clim = NULL,
  year_dim = "year",
  month_dim = "month",
  na.rm = TRUE,
  ncores = NULL
)
}
\arguments{
\item{data_tas}{A numerical array  with the surface air temperature data
to be used for the index computation with, at least, the
dimensions: 1) latitude, longitude, start date and forecast month 
(in case of decadal predictions), 2) latitude, longitude, year and month 
(in case of historical simulations or observations). This data has to be 
provided, at least, over the whole region needed to compute the index.
The dimensions must be identical to thos of data_tos.}

\item{data_tos}{A numerical array  with the sea surface temperature data
to be used for the index computation with, at least, the
dimensions: 1) latitude, longitude, start date and forecast month 
(in case of decadal predictions), 2) latitude, longitude, year and month 
(in case of historical simulations or observations). This data has to be 
provided, at least, over the whole region needed to compute the index.
The dimensions must be identical to thos of data_tas.}

\item{data_lats}{A numeric vector indicating the latitudes of the data.}

\item{data_lons}{A numeric vector indicating the longitudes of the data.}

\item{mask_sea_land}{An array with dimensions [lat_dim = data_lats, lon_dim =
data_lons] for blending 'data_tas' and 'data_tos'.}

\item{sea_value}{A numeric value indicating the sea grid points in
'mask_sea_land'.}

\item{type}{A character string indicating the type of data ('dcpp' for 
decadal predictions, 'hist' for historical simulations, or 'obs' for 
observations or reanalyses).}

\item{mask}{An array of a mask (with 0's in the grid points that have to be 
masked) or NULL (i.e., no mask is used). This parameter allows to remove 
the values over land in case the dataset is a combination of surface air 
temperature over land and sea surface temperature over the ocean. Also, it
can be used to mask those grid points that are missing in the observational
dataset for a fair comparison between the forecast system and the reference
dataset. The default value is NULL.}

\item{lat_dim}{A character string of the name of the latitude dimension. The
default value is 'lat'.}

\item{lon_dim}{A character string of the name of the longitude dimension. The
default value is 'lon'.}

\item{monini}{An integer indicating the month in which the forecast system is
initialized. Only used when parameter 'type' is 'dcpp'. The default value 
is 11, i.e., initialized in November.}

\item{fmonth_dim}{A character string indicating the name of the forecast
month dimension. Only used if parameter 'type' is 'dcpp'. The default value
is 'fmonth'.}

\item{sdate_dim}{A character string indicating the name of the start date 
dimension. Only used if parameter 'type' is 'dcpp'. The default value is 
'sdate'.}

\item{indices_for_clim}{A numeric vector of the indices of the years to
compute the climatology for calculating the anomalies, or NULL so the 
climatology is calculated over the whole period. If the data are already 
anomalies, set it to FALSE. The default value is NULL.\cr
In case of parameter 'type' is 'dcpp', 'indices_for_clim' must be relative 
to the first forecast year, and the climatology is automatically computed 
over the common calendar period for the different forecast years.}

\item{year_dim}{A character string indicating the name of the year dimension
The default value is 'year'. Only used if parameter 'type' is 'hist' or 
'obs'.}

\item{month_dim}{A character string indicating the name of the month
dimension. The default value is 'month'. Only used if parameter 'type' is 
'hist' or 'obs'.}

\item{na.rm}{A logical value indicanting whether to remove NA values. The default 
value is TRUE.}

\item{ncores}{An integer indicating the number of cores to use for parallel 
computation. The default value is NULL.}
}
\value{
A numerical array with the GMST anomalies with the same dimensions as data_tas except 
 the lat_dim, lon_dim and fmonth_dim (month_dim) in case of decadal predictions 
 (historical simulations or observations). In case of decadal predictions, a new dimension
 'fyear' is added.
}
\description{
The Global Mean Surface Temperature (GMST) anomalies are computed as the
weighted-averaged surface air temperature anomalies over land and sea surface
temperature anomalies over the ocean. If different members and/or datasets are provided, 
the climatology (used to calculate the anomalies) is computed individually for all of them.
}
\examples{
## Observations or reanalyses
obs_tas <- array(1:100, dim = c(year = 5, lat = 19, lon = 37, month = 12))
obs_tos <- array(2:101, dim = c(year = 5, lat = 19, lon = 37, month = 12))
mask_sea_land <- array(c(1,0,1), dim = c(lat = 19, lon = 37))
sea_value <- 1
lat <- seq(-90, 90, 10)
lon <- seq(0, 360, 10)
index_obs <- GMST(data_tas = obs_tas, data_tos = obs_tos, data_lats = lat,
                  data_lons = lon, type = 'obs', 
                  mask_sea_land = mask_sea_land, sea_value = sea_value)

## Historical simulations
hist_tas <- array(1:100, dim = c(year = 5, lat = 19, lon = 37, month = 12, member = 5))
hist_tos <- array(2:101, dim = c(year = 5, lat = 19, lon = 37, month = 12, member = 5))
mask_sea_land <- array(c(1,0,1), dim = c(lat = 19, lon = 37))
sea_value <- 1
lat <- seq(-90, 90, 10)
lon <- seq(0, 360, 10)
index_hist <- GMST(data_tas = hist_tas, data_tos = hist_tos, data_lats = lat, 
                   data_lons = lon, type = 'hist', mask_sea_land = mask_sea_land, 
                   sea_value = sea_value)

## Decadal predictions
dcpp_tas <- array(1:100, dim = c(sdate = 5, lat = 19, lon = 37, fmonth = 24, member = 5))
dcpp_tos <- array(2:101, dim = c(sdate = 5, lat = 19, lon = 37, fmonth = 24, member = 5))
mask_sea_land <- array(c(1,0,1), dim = c(lat = 19, lon = 37))
sea_value <- 1
lat <- seq(-90, 90, 10)
lon <- seq(0, 360, 10)
index_dcpp <- GMST(data_tas = dcpp_tas, data_tos = dcpp_tos, data_lats = lat, 
                   data_lons = lon, type = 'dcpp', monini = 1, mask_sea_land = mask_sea_land,
                   sea_value = sea_value)

}
