% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulation.R
\name{AddOutlier}
\alias{AddOutlier}
\title{Add outlier to matrix}
\usage{
AddOutlier(X, proportion, value, seed = NULL, method = "element")
}
\arguments{
\item{X}{\code{matrix}, to which outliers are added}

\item{proportion}{\code{numeric}, proportion of elements, rows or columns to be contaminated. 
Must be between 0 and 1.}

\item{value}{\code{numeric}, the outlying value to be used for contamination}

\item{seed}{\code{numeric}, a seed to reproduce the randomization behaviour}

\item{method}{\code{character}, must be one of the following:
\itemize{
\item \code{"element"} - For contaminating at random positions of the matrix
\item \code{"row"} - For contaminating an entire row of the matrix
\item \code{"col"} - For contaminating an entire column of the matrix
}}
}
\value{
A \code{matrix} with elements / rows / columns contaminated.
}
\description{
\code{AddOutlier} returns a matrix with outliers randomly added to a matrix
 given certain proportion of contamination
}
\note{
Due to randomization, it is possible that the none of the entries of the matrix 
become contaminated. In that case, it is recommended to use different seed value.
}
\examples{
X = matrix(1:20, nrow = 4, ncol = 5)
AddOutlier(X, 0.5, 10, seed = 1234)
}
