% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{example1_rosen_nograd_bfgs}
\alias{example1_rosen_nograd_bfgs}
\title{Example 1: Minimize Rosenbrock function (with numerical gradient) using BFGS}
\usage{
example1_rosen_nograd_bfgs()
}
\description{
Minimize Rosenbrock function (with numerical gradient) using BFGS.
}
\examples{
fr <- function(x) {   ## Rosenbrock Banana function
 x1 <- x[1]
 x2 <- x[2]
 100 * (x2 - x1 * x1)^2 + (1 - x1)^2
}

optim(c(-1.2,1), fr, NULL, method = "BFGS")

## corresponding C++ implementation:
example1_rosen_nograd_bfgs()
}
