% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{partialOrder}
\alias{partialOrder}
\title{Find partial order of smallest or largest values}
\usage{
partialOrder(x, h, decreasing = FALSE)
}
\arguments{
\item{x}{a numeric vector of which to find the order of the smallest or
largest elements.}

\item{h}{an integer specifying how many (smallest or largest) elements to
order.}

\item{decreasing}{a logical indicating whether the sort order should be
increasing (\code{FALSE}; the default) or decreasing (\code{TRUE}).}
}
\value{
An integer vector containing the indices of the \code{h} smallest or
largest elements of \code{x}.
}
\description{
Obtain a partial permutation that rearranges the smallest (largest) elements
of a vector into ascending (descending) order.
}
\examples{
# randomly draw some values
values <- rnorm(10)
values

# find largest observations
partialOrder(values, 5, decreasing = TRUE)

}
\seealso{
\code{\link{order}}
}
\author{
Andreas Alfons
}
\keyword{utilities}
