% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getParam.R
\name{getParam}
\alias{getParam}
\title{Wrapper around the \code{params} global variable}
\usage{
getParam(name, default = NA)
}
\arguments{
\item{name}{Name of the parameter}

\item{default}{Default value to be returned if the \code{params} global variable does not exist,
which typically occurs if the script is executed outside of the \code{Makefile}.}
}
\value{
The function returns an element of the given \code{name} from the \code{params} variable that is created
inside the \code{Makefile} recipe. If the \code{params} global variable does not exist (the script
is likely being executed directly, i.e., not from the Makefile generated by \code{rmake}),
the \code{default} value is returned and a warning is generated. If the \code{params} global variable
exists but it is not a list or the \code{name} element does not exist in it, an error is thrown.
}
\description{
Returns an element of the global \code{params} variable that is normally used to send parameters
to a script from the \code{Makefile} generated by \code{rmake}. Script parameters may be defined with
the \code{params} argument of the \code{\link[=rRule]{rRule()}} or \code{\link[=markdownRule]{markdownRule()}} functions.
}
\examples{
task <- getParam('task', 'default')

}
\seealso{
\code{\link[=rRule]{rRule()}}, \code{\link[=markdownRule]{markdownRule()}}
}
\author{
Michal Burda
}
