% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/comp_popu.R
\docType{data}
\name{popu}
\alias{popu}
\title{A table of cases (in the current population).}
\format{
An object of class \code{NULL} of length 0.
}
\usage{
popu
}
\value{
A data frame \code{popu}
containing \code{\link{N}} rows (individual cases)
and 3 columns (\code{"Truth", "Decision", "SDT"})
encoded as ordered factors
(with 2, 2, and 4 levels, respectively).
}
\description{
\code{popu} is an R data frame that is computed
by \code{\link{comp_popu}} from the current
frequency information (contained in \code{\link{freq}}).
Each individual is represented as a row;
columns represent the individual's
condition (\code{TRUE} or \code{FALSE}),
a corresponding decision
(also encoded as \code{TRUE} = positive or \code{FALSE} = negative),
and its classification (i.e., its case or cell combination, in SDT terms), as
true positive (hit \code{\link{hi}}),
false negative (miss \code{\link{mi}}),
false positive (false alarm \code{\link{fa}}), or
true negative (correct rejection \code{\link{cr}}).
}
\details{
#' \code{popu} is initialized to \code{NULL}
and needs to be computed by calling \code{\link{comp_popu}}
with current parameter settings.

By default, \code{\link{comp_popu}} uses the current information
contained in \code{\link{txt}} to define text labels.

A visualization of the current population
\code{popu} is provided by \code{\link{plot_icons}}.
}
\examples{
popu <- comp_popu()  # => initializes popu with current values of freq and txt
dim(popu)            # => N x 3
head(popu)           # => shows head of data frame

}
\seealso{
the corresponding generating function \code{\link{comp_popu}};
\code{\link{read_popu}} interprets a data frame as a riskyr scenario;
\code{\link{num}} for basic numeric parameters;
\code{\link{freq}} for current frequency information;
\code{\link{txt}} for current text settings.
}
\keyword{datasets}
