% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/init_freq.R
\docType{data}
\name{dec_err}
\alias{dec_err}
\title{Number of individuals for which the decision is erroneous.}
\format{
An object of class \code{numeric} of length 1.
}
\usage{
dec_err
}
\description{
\code{dec_err} is a frequency that describes the
number of individuals in the current population \code{\link{N}}
for which the decision is incorrect or erroneous (i.e., cases in which the
decision does not correspond to the condition).
}
\details{
Key relationships:

\enumerate{

\item to probabilities:
The frequency of \code{dec_err} individuals depends on the population size \code{\link{N}} and
is equal to the sum of false negatives \code{\link{mi}} and false positives \code{\link{fa}}.

\item to other frequencies:
In a population of size \code{\link{N}} the following relationships hold:

  \itemize{

    \item \code{\link{N} = \link{cond_true} + \link{cond_false}} (by condition)

    \item \code{\link{N} = \link{dec_pos} + \link{dec_neg}} (by decision)

    \item \code{\link{N} = \link{dec_cor} + \link{dec_err}} (by correspondence of decision to condition)

    \item \code{\link{dec_cor} = \link{hi} + \link{cr}}

    \item \code{\link{dec_err} = \link{mi} + \link{fa}}

    \item \code{\link{N}  =  \link{hi} + \link{mi} + \link{fa} + \link{cr}} (by condition x decision)
  }
}

Current frequency information is computed by
\code{\link{comp_freq}} and contained in a list
\code{\link{freq}}.
}
\examples{
dec_err <- 1000 * .50   # => sets dec_err to 50\% of 1000 = 500 cases.
is_freq(dec_err)        # => TRUE
is_prob(dec_err)        # => FALSE, as dec_err is no probability (but acc, bacc/wacc ARE)
}
\references{
Consult \href{https://en.wikipedia.org/wiki/Confusion_matrix}{Wikipedia: Confusion matrix} for additional information.
}
\seealso{
\code{\link{is_freq}} verifies frequencies;
\code{\link{num}} contains basic numeric parameters;
\code{\link{init_num}} initializes basic numeric parameters;
\code{\link{freq}} contains current frequency information;
\code{\link{comp_freq}} computes current frequency information;
\code{\link{prob}} contains current probability information;
\code{\link{comp_prob}} computes current probability information.

Other frequencies: 
\code{\link{N}},
\code{\link{cond_false}},
\code{\link{cond_true}},
\code{\link{cr}},
\code{\link{dec_cor}},
\code{\link{dec_neg}},
\code{\link{dec_pos}},
\code{\link{fa}},
\code{\link{hi}},
\code{\link{mi}}
}
\concept{frequencies}
\keyword{datasets}
