% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/text.R
\name{get_text_tei}
\alias{get_text_tei}
\title{Retrieve a text for a play in 'TEI'}
\usage{
get_text_tei(play = NULL, corpus = NULL, ...)
}
\arguments{
\item{play}{Character, name of a play (you can find all play names in
\code{"playName"} column within an object returned by
\code{\link{get_dracor}}). Character vector (longer than 1) is not
supported.}

\item{corpus}{Character, name of the corpus (you can find all corpus names in
\code{name} column within an object returned by
\code{\link{get_dracor_meta}}).}

\item{...}{Additional arguments passed to \code{\link{dracor_api}}.}
}
\value{
TEI data parsed by
  {\code{\link[xml2:read_xml]{xml2::read_xml()}}}.
}
\description{
\code{get_text_tei()} requests a text for a play in 'TEI' format, given play
and corpus names. 'TEI' is an XML vocabulary, which makes it easy to extract
structural information \insertCite{fischer2019programmable}{rdracor}.
}
\examples{
get_text_tei(play = "lessing-emilia-galotti", corpus = "ger")
# If you want a text in TEI without parsing by xml2::read_xml():
get_text_tei(play = "lessing-emilia-galotti", corpus = "ger", parse = FALSE)
}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{get_text_df}} \code{\link{get_text_chr_spoken}}
\code{\link{tei_to_df}}
}
