% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.plot.R
\name{plot.ena.set}
\alias{plot.ena.set}
\title{Plot an ena.set object}
\usage{
\method{plot}{ena.set}(x, y, ..., empty = TRUE, title = "ENA Plot")
}
\arguments{
\item{x}{ena.set to plot}

\item{y}{ignored.}

\item{...}{Additional parameters passed along to ena.plot functions}

\item{empty}{Logical; if TRUE, creates an empty plot without points. Default is TRUE.}

\item{title}{Character; title for the plot. Default is "ENA Plot".}
}
\value{
ena.plot.object
}
\description{
Plot an ena.set object
}
\examples{

data(RS.data)

codeNames = c('Data','Technical.Constraints','Performance.Parameters',
  'Client.and.Consultant.Requests','Design.Reasoning','Collaboration');

accum = ena.accumulate.data(
  units = RS.data[,c("UserName","Condition")],
  conversation = RS.data[,c("Condition","GroupName")],
  metadata = RS.data[,c("CONFIDENCE.Change","CONFIDENCE.Pre","CONFIDENCE.Post")],
  codes = RS.data[,codeNames],
  window.size.back = 4
)

set = ena.make.set(
  enadata = accum
)

plot(set) |>
  add_points(Condition$FirstGame, colors = "blue", with.mean = TRUE) |>
  add_points(Condition$SecondGame, colors = "red", with.mean = TRUE) |>
  with_means() |>
  add_nodes()

myENAplot <- plot(set) |>
  add_network(Condition$FirstGame - Condition$SecondGame)


# Add a group mean to an existing ENA plot
add_group(myENAplot, wh = Condition$FirstGame)

# Add a trajectory to an existing ENA plot
add_trajectory(myENAplot, wh = Condition$FirstGame)

# Load test data
data(RS.data);

# Define codenames for the test
codenames <- c("Data", "Technical.Constraints", "Performance.Parameters",
  "Client.and.Consultant.Requests", "Design.Reasoning", "Collaboration");

# Standard ENA accumulation
accum <- rENA:::ena.accumulate.data.file(
  RS.data, units.by = c("UserName", "Condition"),
  conversations.by = c("ActivityNumber", "GroupName"),
  codes = codenames
);
# Create a standard ENA set 
newset <- ena.make.set(accum);

# Simple plot for a set of points, and their mean
newplot <- plot(newset) |> 
  add_points(Condition$FirstGame, mean = TRUE, colors = "blue") |> 
  add_network();

# Plot a single unit's point and it's line.weights
plot(newset) |> 
  add_points(UserName$`steven z`) |> 
  add_network();

# Trajectory accumulation and plotting
trajectory_accumulation <- rENA:::ena.accumulate.data.file(
  RS.data, units.by = c("UserName", "Condition"),
  conversations.by = c("ActivityNumber", "GroupName"),
  codes = codenames,
  model = "A"
);
trajectory_model <- ena.make.set(trajectory_accumulation);

newplot3 <- plot(trajectory_model) |> 
  add_trajectory(Condition$FirstGame);
}
