% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/piped.R
\name{model}
\alias{model}
\title{Build a Complete ENA Model}
\usage{
model(
  data,
  ...,
  normalize = sphere_norm,
  center_with = center,
  rotate_with = rotate,
  project_with = project,
  optimize_with = optimize,
  rotate_fun = ena.rotate.by.generalized,
  rotate_params = list()
)
}
\arguments{
\item{data}{An `ena.set` object, typically the result of `accumulate()`.}

\item{...}{Additional arguments passed to the rotation function specified by `rotate_fun`.}

\item{normalize}{A function to normalize the connection counts. Defaults to `sphere_norm`.}

\item{center_with}{A function to center the normalized data. Defaults to `center`.}

\item{rotate_with}{A function to perform the rotation (e.g., SVD). Defaults to `rotate`.}

\item{project_with}{A function to project the points into the rotated space. Defaults to `project`.}

\item{optimize_with}{A function to optimize node positions. Defaults to `optimize`. Can be set to `NULL` or `FALSE` to skip.}

\item{rotate_fun}{The specific rotation function to be used by `rotate_with`. Defaults to `ena.rotate.by.generalized`.}

\item{rotate_params}{A list of additional parameters to pass to the `rotate_fun`.}
}
\value{
An `ena.set` object with a complete ENA model, including projected points and node positions.
}
\description{
This function applies a full ENA modeling pipeline to accumulated data. It is a convenience wrapper that chains together normalization, centering, rotation, projection, and optional optimization. Each step can be customized by supplying an alternative function.
}
\examples{
data(RS.data)

codes <- c("Data", "Technical.Constraints", "Performance.Parameters",
           "Client.and.Consultant.Requests", "Design.Reasoning",
           "Collaboration")
units <- c("Condition", "UserName")
horizon <- c("Condition", "GroupName")
enaset <- RS.data |>
  accumulate(units, codes, horizon) |>
  model()
}
