% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model_fitting.R
\name{qbrms}
\alias{qbrms}
\title{Quick Bayesian Regression Models with Automatic Routing}
\usage{
qbrms(
  formula,
  data,
  family = gaussian(),
  prior = NULL,
  sample_prior = "no",
  quantile = 0.5,
  control.compute = list(dic = TRUE, waic = TRUE, cpo = TRUE),
  verbose = getOption("qbrms.verbose", FALSE),
  ...
)
}
\arguments{
\item{formula}{Model formula in lme4/brms style}

\item{data}{Data frame containing the variables in the model}

\item{family}{Model family (default: gaussian()). Ordinal families automatically route to qbrmO()}

\item{prior}{Prior specifications (default: NULL)}

\item{sample_prior}{Whether to sample from priors ("no", "yes", "only"). Default: "no"}

\item{quantile}{For asymmetric_laplace family, which quantile to estimate (default: 0.5)}

\item{control.compute}{INLA control settings for model information criteria}

\item{verbose}{Logical; print diagnostic information (default: getOption("qbrms.verbose", FALSE))}

\item{...}{Additional arguments passed to fitting functions}
}
\value{
An object of class \code{"qbrms_fit"} (or \code{"qbrmO_fit"} for ordinal models).
The object is a list containing:
\itemize{
\item \code{fit}: The internal model fit (INLA or TMB object).
\item \code{model_type}: String indicating the type of model fitted.
\item \code{data}: The data used for fitting.
\item \code{original_formula}: The formula used.
\item \code{prior_samples}: Prior predictive samples (if requested).
}
}
\description{
Enhanced qbrms interface with automatic routing to specialised implementations.
Supports ordinal regression via TMB, quantile regression, and all standard INLA families.
}
\seealso{
\code{\link{qbrmO}} for direct ordinal model fitting
}
