% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mscale.R
\name{mscale}
\alias{mscale}
\title{Robust M-estimate of Scale}
\usage{
mscale(
  x,
  delta = 0.5,
  rho = c("bisquare", "huber", "gauss"),
  cc,
  eps = 1e-08,
  maxit = 200
)
}
\arguments{
\item{x}{numeric vector.}

\item{delta}{desired value for the right-hand side of the M-estimation equation.}

\item{rho}{rho function to use in the M-estimation equation. Valid options
are \code{bisquare}, \code{huber} and \code{gauss}.}

\item{cc}{non-negative constant for the chosen rho function. If missing, it will be
chosen such that the expected value of the rho function under the normal model
is equal to \code{delta}.}

\item{eps}{threshold for convergence. Defaults to \code{1e-8}.}

\item{maxit}{maximum number of iterations. Defaults to \code{200}.}
}
\value{
Numeric vector of length one containing the solution \code{s_n} to
the equation above.
}
\description{
Compute the M-estimate of scale using the MAD as initial estimate.
}
\details{
This solves the M-estimation equation given by
\deqn{\sum_{i=1}^n \rho( x_i / s_n; cc ) = n delta}

All \code{NA} values in \code{x} are removed before calculating the scale.
}
