% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/x_from_power_for_x_summary.R
\name{summary.x_from_power}
\alias{summary.x_from_power}
\alias{summary.n_region_from_power}
\alias{print.summary.x_from_power}
\alias{print.summary.n_region_from_power}
\title{Summarize 'x_from_power' Results}
\usage{
\method{summary}{x_from_power}(object, ...)

\method{summary}{n_region_from_power}(object, ...)

\method{print}{summary.x_from_power}(x, digits = 3, ...)

\method{print}{summary.n_region_from_power}(x, digits = 3, ...)
}
\arguments{
\item{object}{An \code{x_from_power}-class
object, such as the output of
\code{\link[=x_from_power]{x_from_power()}}, or an object of the
class \code{n_region_from_power}, such as
the output of
\code{\link[=n_region_from_power]{n_region_from_power()}}.}

\item{...}{Additional arguments.
Not used for now.}

\item{x}{The output of
\code{\link[=summary.x_from_power]{summary.x_from_power()}}, the
\code{summary} method of
an \code{x_from_power} object,
which is the output of
\code{\link[=x_from_power]{x_from_power()}}, or the output
of \code{\link[=summary.n_region_from_power]{summary.n_region_from_power()}},
the \code{summary} method of an
\code{n_region_from_power} object (the
output of \code{\link[=n_region_from_power]{n_region_from_power()}}).}

\item{digits}{The number of digits
after the decimal when printing
the results.}
}
\value{
The \code{summary} method for
\code{x_from_power} objects returns an
object of the class
\code{summary.x_from_power}, which is
simply the output of \code{\link[=x_from_power]{x_from_power()}},
with a \code{print} method dedicated for
detailed summary. Please refer
to \code{\link[=x_from_power]{x_from_power()}} for the contents.

The \code{print}-method of \code{summary.x_from_power}
objects returns the object \code{x}
invisibly.
It is called for its side effect.

The \code{print}-method of \code{summary.n_region_from_power}
objects returns the object \code{x}
invisibly.
It is called for its side effect.
}
\description{
The summary method of
the output of \code{\link[=x_from_power]{x_from_power()}}.
}
\details{
The \code{summary} method simply prepares the
results of \code{\link[=x_from_power]{x_from_power()}}
to be printed in details.
}
\examples{

# Specify the population model

mod <-
"
m ~ x
y ~ m + x
"

# Specify the population values

mod_es <-
"
m ~ x: m
y ~ m: l
y ~ x: n
"

# Generate the datasets

sim_only <- power4test(nrep = 5,
                       model = mod,
                       pop_es = mod_es,
                       n = 100,
                       do_the_test = FALSE,
                       iseed = 2345)

# Do a test

test_out <- power4test(object = sim_only,
                       test_fun = test_parameters,
                       test_args = list(pars = "m~x"))

# Determine the sample size with a power of .80 (default)

power_vs_n <- x_from_power(test_out,
                           x = "n",
                           progress = TRUE,
                           target_power = .80,
                           final_nrep = 5,
                           max_trials = 1,
                           seed = 1234)
summary(power_vs_n)

}
\seealso{
\code{\link[=x_from_power]{x_from_power()}},
\code{\link[=n_region_from_power]{n_region_from_power()}}
}
