% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/normalize_zero_one.R
\name{zero_one_scale}
\alias{zero_one_scale}
\title{Zero to One scaling}
\usage{
zero_one_scale(e_data, edata_id)
}
\arguments{
\item{e_data}{e_data a \eqn{p \times n + 1} data.frame, where \eqn{p} is the
number of peptides, lipids, or metabolites and \eqn{n} is the number of
samples. Each row corresponds to data for a peptide, protein, lipid, or
metabolite, with one column giving the biomolecule identifier name.}

\item{edata_id}{character string indicating the name of the peptide, protein,
lipid, or metabolite identifier. Usually obtained by calling
\code{attr(omicsData, "cnames")$edata_cname}.}
}
\value{
List containing two elements: \code{norm_params} is list with two
  elements:
\tabular{ll}{
scale \tab Range of each sample used in scaling \cr
\tab \cr
location \tab NULL
\cr
}

\code{backtransform_params} is a list with two elements:
\tabular{ll}{
scale \tab NULL \cr
\tab \cr
location \tab NULL
\cr
}

The transformed data is returned as a third
list item.
}
\description{
Re-scales the data to be between 0 and 1
}
\details{
The sample-wise minimum of the features is subtracted from each 
feature in e_data, then divided by the difference between the sample-wise 
minimum and maximum of the features to get the normalized data. The location 
estimates are not applicable for this data and the function returns a NULL 
list element as a placeholder. The scale estimates are the sample-wise 
feature ranges. All NA values are replcaed with zero.
}
\author{
Lisa Bramer, Kelly Stratton, Rachel Richardson
}
