% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{USvote2016}
\alias{USvote2016}
\title{Self-reported votes from VOTER Survey in 2016}
\format{
\code{tibble} (\code{data.frame}) with 8000 observations of 7 variables:
\describe{
\item{idcode:}{voter identifier (integer).}
\item{vote:}{declared vote, afactor with three levels: \emph{Clinton}, \emph{Trump},
\emph{Other}.}
\item{race:}{race, a factor with six levels: \emph{White}, \emph{Black}, \emph{Hispanic},
\emph{Asian}, \emph{Mixed},
\emph{Other}.}
\item{educ:}{level of education, a factor with six levels: \emph{No high school},
\emph{High school grad.}, \emph{Some college}, \emph{2-year college}, \emph{4-year college},
\emph{Post-grad}.}
\item{gender:}{gender, a factor with four levels: \emph{Male}, \emph{Female},
\emph{Skipped}, \emph{Not Asked}.}
\item{birthyr:}{decades when the voter was born, a factor with six levels:
\emph{[1920,1940)}, \emph{[1940,1950)}, \emph{[1950,1960)}, \emph{[1960,1970)}, \emph{[1970,1980)},
\emph{[1980,2000)}.}
\item{famincome:}{income (in USD) of voter's family, a factor with five
levels: \emph{[0; 30,000)}, \emph{[30,000; 60,000)}, \emph{[60,000; 100,000)},
\emph{[100,000; 150,000)}, \emph{[150,000; Inf)}.}
}
}
\description{
Dataset based on self-reported votes from 2016 VOTER Survey by
\insertCite{dfvsg2017;textual}{plot3logit}, as used in the examples in
\insertCite{santi2022;textual}{plot3logit}.
}
\details{
Object \code{USvote2016} includes only
few variables based on the result of the survey, which are publicly available
online. See file \code{"data-raw/USvote2016_prepare.R"} in the GitHub repository
\code{"f-santi/plot3logit"} (\url{https://github.com/f-santi/plot3logit}), where
it is documented how the dataset \code{USvote2016} has been generated.
}
\references{
\insertAllCited{}
}
\keyword{data}
