% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spct.insert.spct.hinges.r
\name{insert_spct_hinges}
\alias{insert_spct_hinges}
\title{Insert new wavelength values into a spectrum}
\usage{
insert_spct_hinges(spct, hinges = NULL, byref = FALSE)
}
\arguments{
\item{spct}{an object of class "generic_spct"}

\item{hinges}{numeric vector of wavelengths (nm) at which the
s.irrad should be inserted by interpolation, no interpolation is indicated
by an empty vector (numeric(0))}

\item{byref}{logical indicating if new object will be created by reference or
by copy of spct}
}
\value{
a generic_spct or a derived type with variables \code{w.length} and
  other numeric variables.
}
\description{
Insert new wavelength values into a spectrum interpolating the corresponding
spectral data values.
}
\note{
Inserting wavelengths values "hinges" immediately before and after a
  discontinuity in the SWF, greatly reduces the errors caused by
  interpolating the weighted irradiance during integration of the effective
  spectral irradiance. This is specially true when data has a large
  wavelength step size.
}
\examples{

insert_spct_hinges(sun.spct, c(399.99,400.00,699.99,700.00))
insert_spct_hinges(sun.spct,
                   c(199.99,200.00,399.50,399.99,400.00,699.99,
                         700.00,799.99,1000.00))
}
