% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/md_future.R
\name{md_future}
\alias{md_future}
\title{query future market data}
\usage{
md_future(symbol, type = "history", date_range = "max", from = NULL,
  to = Sys.Date(), freq = "daily", print_step = 1L, ...)
}
\arguments{
\item{symbol}{future symbols It is available via function \code{md_future_symbol} or its website.}

\item{type}{the data type, including history, real and info. Default is history.}

\item{date_range}{date range. Available value includes '1m'-'11m', 'ytd', 'max' and '1y'-'ny'. Default is max.}

\item{from}{the start date. Default is NULL. If it is NULL, then calculate using date_range and end date.}

\item{to}{the end date. Default is the current date.}

\item{freq}{data frequency, default is daily.}

\item{print_step}{a non-negative integer, which will print symbol name by each print_step iteration. Default is 1L.}

\item{...}{Additional parameters.}
}
\description{
\code{md_future} query future market data from sina finance, \url{https://finance.sina.com.cn/futuremarket/}.
}
\examples{
\dontrun{
# history data
df_hist = md_future(symbol = c('IF0', 'A0', 'CU0', 'CF0', 'XAU'))

# real data
df_real = md_future(symbol = c('IF0', 'A0', 'CU0', 'CF0', 'XAU'), 
                    type = 'real')
}


}
