% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prune.R
\name{orderly_prune_orphans}
\alias{orderly_prune_orphans}
\title{Prune orphan packet metadata}
\usage{
orderly_prune_orphans(root = NULL)
}
\arguments{
\item{root}{The path to the root directory, or \code{NULL} (the
default) to search for one from the current working
directory. This function does not require that the directory is
configured for orderly, and can be any \code{outpack} root (see
\code{\link[=orderly_init]{orderly_init()}} for details).}
}
\value{
Invisibly, a character vector of orphaned packet ids
}
\description{
Prune orphan packets from your metadata store.  This function can
be used to remove references to packets that are no longer
reachable; this could have happened because you deleted a packet
manually from the archive and ran
\code{\link[=orderly_validate_archive]{orderly_validate_archive()}} or because you removed a
location.
}
\details{
If an orphan packet is not used anywhere, then we can easily drop
it - it's as if it never existed.  If it is referenced by metadata
that you know about from elsewhere but not locally, then that is a
problem for the upstream location (and one that should not
happen). If you have referenced it in a packet that you have run
locally, the the metadata is not deleted.

We expose this function mostly for users who want to expunge
permanently any reference to previously run packets. We hope that
there should never need to really be a reason to run it.
}
\examples{
# The same example as orderly_validate_archive; a corrupted
# archive due to the local deletion of a file
# Start with an archive containing 4 simple packets
path <- orderly_example()
ids <- vapply(1:4, function(i) orderly_run("data", root = path), "")
fs::file_delete(file.path(path, "archive", "data", ids[[3]], "data.rds"))

# Validate the archive ands orphan corrupt packets:
orderly_validate_archive(action = "orphan", root = path)

# Prune our orphans:
orderly_prune_orphans(root = path)
}
