% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/location.R
\name{orderly_location_push}
\alias{orderly_location_push}
\title{Push tree to location}
\usage{
orderly_location_push(
  expr,
  location,
  name = NULL,
  dry_run = FALSE,
  root = NULL
)
}
\arguments{
\item{expr}{An expression to search for.  Often this will be a
vector of ids, but you can use a query here.}

\item{location}{The name of a location to push to (see
\code{\link[=orderly_location_list]{orderly_location_list()}} for possible values).}

\item{name}{Optionally, the name of the packet to scope the query on. This
will be intersected with \code{scope} arg and is a shorthand way of running
\code{scope = list(name = "name")}}

\item{dry_run}{Logical, indicating if we should print a summary
but not make any changes.}

\item{root}{The path to the root directory, or \code{NULL} (the
default) to search for one from the current working
directory. This function does not require that the directory is
configured for orderly, and can be any \code{outpack} root (see
\code{\link[=orderly_init]{orderly_init()}} for details).}
}
\value{
Invisibly, details on the information that was actually
moved (which might be more or less than what was requested,
depending on the dependencies of packets and what was already
known on the other location).
}
\description{
Push tree to location. This function works out what packets are
not known at the location and then what files are required to
create them. It then pushes all the files required to build all
packets and then pushes the missing metadata to the server. If the
process is interrupted it is safe to resume and will only transfer
files and packets that were missed on a previous call.
}
\examples{
# Two roots, one local and one representing some remote orderly
# location.  The remote location must use a file store at present.
local <- orderly_example()
remote <- orderly_example(use_file_store = TRUE)
orderly_location_add_path("remote", remote, root = local)

# We create a packet in the local root:
id <- orderly_run("data", root = local)

# Push a packet into our remote version
orderly_location_push(id, location = "remote", root = local)
}
