% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class-workbook-wrappers.R
\name{wb_add_hyperlink}
\alias{wb_add_hyperlink}
\alias{wb_remove_hyperlink}
\title{wb_add_hyperlink}
\usage{
wb_add_hyperlink(
  wb,
  sheet = current_sheet(),
  dims = "A1",
  target = NULL,
  tooltip = NULL,
  is_external = TRUE,
  col_names = FALSE
)

wb_remove_hyperlink(wb, sheet = current_sheet(), dims = NULL)
}
\arguments{
\item{wb}{A Workbook object containing a worksheet.}

\item{sheet}{The worksheet to write to. (either as index or name)}

\item{dims}{Spreadsheet dimensions that will determine where the hyperlink reference spans: "A1", "A1:B2", "A:B"}

\item{target}{An optional target, if no target is specified, it is assumed that the cell already contains a reference (the cell could be a url or a filename)}

\item{tooltip}{An optional description for a variable that will be visible when hovering over the link text in the spreadsheet}

\item{is_external}{A logical indicating if the hyperlink is external (a url, a mail address, a file) or internal (a reference to worksheet cells)}

\item{col_names}{Whether or not the object contains column names. If yes the first column of the dimension will be ignored}
}
\description{
Helper to add shared hyperlinks into a worksheet or remove shared hyperlinks from a worksheet
}
\details{
There are multiple ways to add hyperlinks into a worksheet. One way is to construct a formula with \code{\link[=create_hyperlink]{create_hyperlink()}} another is to assign a class \code{hyperlink} to a column of a data frame.
Contrary to the previous method, shared hyperlinks are not cell formulas in the worksheet, but references in the worksheet relationship and hyperlinks in the worksheet xml structure.
These shared hyperlinks can be reused and they are not visible to spreadsheet users as \code{HYPERLINK()} formulas.
}
\examples{
wb <- wb_workbook()$add_worksheet()$
  add_data(x = "openxlsx2 on CRAN")$
  add_hyperlink(target = "https://cran.r-project.org/package=openxlsx2",
                tooltip = "The canonical form to link to our CRAN page.")

wb$remove_hyperlink()
}
\seealso{
Other workbook wrappers: 
\code{\link{base_font-wb}},
\code{\link{col_widths-wb}},
\code{\link{creators-wb}},
\code{\link{grouping-wb}},
\code{\link{row_heights-wb}},
\code{\link{wb_add_chartsheet}()},
\code{\link{wb_add_data}()},
\code{\link{wb_add_data_table}()},
\code{\link{wb_add_formula}()},
\code{\link{wb_add_pivot_table}()},
\code{\link{wb_add_slicer}()},
\code{\link{wb_add_worksheet}()},
\code{\link{wb_base_colors}},
\code{\link{wb_clone_worksheet}()},
\code{\link{wb_copy_cells}()},
\code{\link{wb_freeze_pane}()},
\code{\link{wb_merge_cells}()},
\code{\link{wb_save}()},
\code{\link{wb_set_last_modified_by}()},
\code{\link{wb_workbook}()}

Other worksheet content functions: 
\code{\link{col_widths-wb}},
\code{\link{filter-wb}},
\code{\link{grouping-wb}},
\code{\link{named_region-wb}},
\code{\link{row_heights-wb}},
\code{\link{wb_add_conditional_formatting}()},
\code{\link{wb_add_data}()},
\code{\link{wb_add_data_table}()},
\code{\link{wb_add_formula}()},
\code{\link{wb_add_pivot_table}()},
\code{\link{wb_add_slicer}()},
\code{\link{wb_add_thread}()},
\code{\link{wb_freeze_pane}()},
\code{\link{wb_merge_cells}()}
}
\concept{workbook wrappers}
\concept{worksheet content functions}
