% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/resample.R
\name{resample_dat_vect}
\alias{resample_dat_vect}
\alias{resample_dat}
\alias{resample_dat_alt}
\title{A function to create an attribute or column for each sample loaded into the microplate wells.}
\usage{
resample_dat_vect(df, tnp, cycles, output = NULL)

resample_dat(df, tnp, cycles)

resample_dat_alt(df, tnp, cycles)
}
\arguments{
\item{df}{A clean data frame with attributes or tuples containing a mixture of samples.}

\item{tnp}{A numeric value indicating the number of rows used. TNP is used as an acronym for Test, Negative, Positive.}

\item{cycles}{A numeric value indicating the number of cycles selected by the user when running the FLUOstar instrument.}

\item{output}{A choice between "df' and 'vector' outputs. Leave NULL for a data frame.}
}
\value{
A new data frame where separated samples are assigned a separate attribute or column.

A new data frame where separated samples are assigned a separate attribute or column.

A new data frame where separated samples are assigned a separate attribute or column.
}
\description{
Designed as a prototype function to take a single attribute or column
consisting of several samples and perform a putative resampling
to yield another data frame with a separate attribute for each sample.

Designed as a prototype function to take a single attribute or column
consisting of several samples and perform a putative resampling
to yield another data frame with a separate attribute for each sample.

: Designed as a prototype function to take a single tuple or row
consisting of several samples and perform a putative resampling to yield
another data frame with a separate attribute for each sample.
}
\note{
This is the vectorized approach and should be a more efficient function when compared to say
}
\examples{
\dontrun{
fpath <- system.file("extdata", "dat_4.dat", package = "normfluodbf", mustWork = TRUE)
dat_df <- read.table(file=fpath)
nocomma_dat <- clean_odddat_optimus(dat_df)
samples_delineated <- resample_dat_vect(nocomma_dat, tnp=3, cycles=40)}
\dontrun{
fpath <- system.file("extdata", "dat_5.dat", package = "normfluodbf", mustWork = TRUE)
dat_df <- read.table(file=fpath)
nocomma_dat <- clean_odddat_optimus(dat_df)
samples_delineated <- resample_dat(nocomma_dat, tnp=3, cycles=40)}
\dontrun{
fpath <- system.file("extdata", "dat_5.dat", package = "normfluodbf", mustWork = TRUE)
dat_df <- read.table(file=fpath)
nocomma_dat <- clean_odddat_optimus(dat_df)
samples_delineated <- resample_dat_alt(nocomma_dat, tnp=3, cycles=40)}
}
\seealso{
\code{\link[=resample_vect_scale]{resample_vect_scale()}}

\code{\link[=resample_dat]{resample_dat()}} or @seealso \code{\link[=resample_dat_alt]{resample_dat_alt()}}.
This function will produce a vertical layout as defined in this package.

\code{\link[=resample_dat_scale]{resample_dat_scale()}}, \code{\link[=resample_dat_scale_optimus]{resample_dat_scale_optimus()}}

\code{\link[=resample_dat_scale_alt]{resample_dat_scale_alt()}}
}
\author{
Tingwei Adeck
}
