% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/makeCFObjects.R
\name{makeAxis}
\alias{makeAxis}
\title{Create an axis}
\usage{
makeAxis(name, orientation, values, bounds = NULL, attributes = NULL)
}
\arguments{
\item{name}{Name of the axis.}

\item{orientation}{The orientation of the axis. Must be one of "X", "Y", "Z",
or "T" for longitude, latitude, height or depth, and time axes,
respectively. For any other axis, indicate an empty string ""}

\item{values}{The coordinate values. In the case of an axis with \code{orientation = "T"} this must be a \code{CFTime} or \code{CFClimatology} instance.}

\item{bounds}{The boundary values of the coordinates, or \code{NULL} if not
available.}

\item{attributes}{\code{data.frame} with the attributes of the axis to create.
Depending on which axis is created one or more attributes may be added or
amended.}
}
\value{
An instance of a class descending from \link{CFAxis}.
}
\description{
With this method you can create an axis to use with new \link{CFVariable}
instances. Depending on the \code{orientation} argument and the type of the
\code{values} argument an instance of a class descending from \link{CFAxis} will be
returned.
}
\details{
There are several restrictions on the combination of \code{orientation} and
\code{values} arguments. Longitude, latitude and depth axes (\code{orientation} of "X",
"Y" or "Z") must have numeric \code{values}. For a time axis (\code{orientation} of
"T") the \code{values} argument must be an instance of \code{CFTime} or
\code{CFClimatology}.
}
\seealso{
\code{\link[=makeLongitudeAxis]{makeLongitudeAxis()}}, \code{\link[=makeLatitudeAxis]{makeLatitudeAxis()}}, \code{\link[=makeTimeAxis]{makeTimeAxis()}},
\code{\link[=makeDiscreteAxis]{makeDiscreteAxis()}}
}
