% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/phyloset_sc.R
\name{downsample_expression}
\alias{downsample_expression}
\title{Downsample Expression Matrix by Groups}
\usage{
downsample_expression(expression_matrix, groups, downsample = 10)
}
\arguments{
\item{expression_matrix}{Expression matrix with genes as rows and samples as columns}

\item{groups}{Factor vector indicating which group each sample belongs to}

\item{downsample}{Integer, number of samples to keep per group (default: 10)}
}
\value{
A dense expression matrix (genes x downsampled samples)
}
\description{
Downsample an expression matrix by randomly selecting a specified number of samples from each group.
}
\details{
This function randomly samples up to \code{downsample} samples from each group level.
The returned expression matrix is converted to dense format and maintains column names
from the original matrix. Useful for creating balanced subsets for visualization or
when memory is limited.
}
