% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prep.R
\name{mc_prep_merge}
\alias{mc_prep_merge}
\title{Merge myClim objects}
\usage{
mc_prep_merge(data_items)
}
\arguments{
\item{data_items}{list of myClim objects see \link{myClim-package}; Format (Raw/Agg) of merged objects must be same.}
}
\value{
merged myClim object in the same format as input objects
}
\description{
This function is designed to merge more existing myClim objects into one.
}
\details{
This function works only when the input myClim objects have the same format
(Raw-format, Agg-format) It is not possible to merge Raw wit Agg format.
Identical time-step is required for Agg-format data.

When the merged myClim objects in Raw-format contains locality with same names (locality_id),
than list of loggers are merged on the locality. Sensors with the same name does not matter here.
Loggers with the same name within the locality are allowed in the Raw-format.

When the merged myClim objects in Agg-format contains locality with same names (locality_id).
than the sensors are merged on the locality. Sensors with same names are renamed.
}
\examples{
merged_data <- mc_prep_merge(list(mc_data_example_raw, mc_data_example_raw))
}
