% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predictStationary.R
\name{predictStationary}
\alias{predictStationary}
\title{Predict stationary state probabilities}
\usage{
predictStationary(
  m,
  newData,
  beta = m$mle$beta,
  returnCI = FALSE,
  alpha = 0.95
)
}
\arguments{
\item{m}{Fitted moveHMM object, as returned by \code{\link{fitHMM}}}

\item{newData}{Data frame with columns for the covariates}

\item{beta}{Optional matrix of regression coefficients for the transition
probability model. By default, uses estimates in \code{m}.}

\item{returnCI}{Logical indicating whether confidence intervals should
be returned. Default: FALSE.}

\item{alpha}{Confidence level if returnCI = TRUE. Default: 0.95, i.e.,
95\% confidence intervals.}
}
\value{
List with elements 'mle', 'lci', and 'uci' (the last two only if
returnCI = TRUE). Each element is a matrix of stationary state probabilities
with one row for each row of newData and one column for each state.
}
\description{
Predict stationary state probabilities
}
