% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PipeOpFDARandomEffect.R
\name{mlr_pipeops_fda.random_effect}
\alias{mlr_pipeops_fda.random_effect}
\alias{PipeOpFDARandomEffect}
\title{Extracts Random Effects from Functional Columns}
\description{
This is the class that extracts random effects, specifically random intercepts and
random slopes, from functional columns. This PipeOp fits a linear mixed model, specifically
a random intercept and random slope model, using the \code{\link[lme4:lmer]{lme4::lmer()}} function.
The target variable is the value of the functional feature which is regressed on the functional feature's argument
while subject id determines the grouping structure. After model estimation, the random effects are extracted and
assigned to the correct id.
}
\section{Parameters}{

The parameters are the parameters inherited from \code{\link[mlr3pipelines:PipeOpTaskPreprocSimple]{PipeOpTaskPreprocSimple}}.
}

\section{Naming}{

The new names append \verb{_random_intercept} and \verb{_random_slope} to the corresponding column name of the
functional feature.
}

\examples{
task = tsk("dti")
po_fre = po("fda.random_effect")
task_fre = po_fre$train(list(task))[[1L]]
}
\section{Super classes}{
\code{\link[mlr3pipelines:PipeOp]{mlr3pipelines::PipeOp}} -> \code{\link[mlr3pipelines:PipeOpTaskPreproc]{mlr3pipelines::PipeOpTaskPreproc}} -> \code{\link[mlr3pipelines:PipeOpTaskPreprocSimple]{mlr3pipelines::PipeOpTaskPreprocSimple}} -> \code{PipeOpFDARandomEffect}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-PipeOpFDARandomEffect-new}{\code{PipeOpFDARandomEffect$new()}}
\item \href{#method-PipeOpFDARandomEffect-clone}{\code{PipeOpFDARandomEffect$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="mlr3pipelines" data-topic="PipeOp" data-id="help"><a href='../../mlr3pipelines/html/PipeOp.html#method-PipeOp-help'><code>mlr3pipelines::PipeOp$help()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3pipelines" data-topic="PipeOp" data-id="predict"><a href='../../mlr3pipelines/html/PipeOp.html#method-PipeOp-predict'><code>mlr3pipelines::PipeOp$predict()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3pipelines" data-topic="PipeOp" data-id="print"><a href='../../mlr3pipelines/html/PipeOp.html#method-PipeOp-print'><code>mlr3pipelines::PipeOp$print()</code></a></span></li>
<li><span class="pkg-link" data-pkg="mlr3pipelines" data-topic="PipeOp" data-id="train"><a href='../../mlr3pipelines/html/PipeOp.html#method-PipeOp-train'><code>mlr3pipelines::PipeOp$train()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PipeOpFDARandomEffect-new"></a>}}
\if{latex}{\out{\hypertarget{method-PipeOpFDARandomEffect-new}{}}}
\subsection{Method \code{new()}}{
Initializes a new instance of this Class
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PipeOpFDARandomEffect$new(id = "fda.random_effect", param_vals = list())}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{id}}{(\code{character(1)}) Identifier of the operator, default is \code{"fda.random_effect"}.}

\item{\code{param_vals}}{(named \code{list()}) List of hyperparameter settings, overwriting
default settings set during construction.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PipeOpFDARandomEffect-clone"></a>}}
\if{latex}{\out{\hypertarget{method-PipeOpFDARandomEffect-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PipeOpFDARandomEffect$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
