% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scoretestindep.R
\name{scoreindep}
\alias{scoreindep}
\title{Ramos and Ledford test of independence}
\usage{
scoreindep(xdat, p, test = c("ledford", "tawn"))
}
\arguments{
\item{xdat}{a \code{n} by 2 matrix of observations}

\item{p}{probability level for the marginal threshold}

\item{test}{string; if \code{tawn}, only censor observations in the upper quadrant when both variables are large as in Tawn (1988), otherwise censor marginally for \code{ledford} as in Ledford and Tawn (1996).}
}
\value{
a list with elements
\describe{
\item{\code{stat}}{value of the score test statistic}
\item{\code{pval}}{asymptotic p-value}
\item{\code{test}}{\code{test} argument}
}
}
\description{
The Ramos and Ledford (2005) score test of independence is a modification of tests by Tawn (1988) and Ledford and Tawn (1996) for a logistic model parameter \eqn{\alpha=1}; the latter two have scores with zero expectation, but the variance of the score are infinite, which produces non-regularity and yield test, once suitably normalized, that converge slowly to their asymptotic null distribution. The test, designed for bivariate samples, transforms observations to have unit Frechet margins and considers a bivariate censored likelihood approach for the logistic distribution.
}
\keyword{internal}
