% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3_classes.R
\name{get_time_to_mcc}
\alias{get_time_to_mcc}
\title{Get Time When MCC Reaches a Specific Threshold}
\usage{
get_time_to_mcc(mcc_data, mcc_column, threshold = 1)
}
\arguments{
\item{mcc_data}{A data frame containing MCC estimates over time. This is
typically the \code{mcc_final} component from an \code{mcc} object.}

\item{mcc_column}{A string specifying the name of the column containing
MCC values. For \code{method = "equation"}, this is typically \code{"mcc"}. For
\code{method = "sci"}, this is typically \code{"SumCIs"}.}

\item{threshold}{numeric;determines MCC value threshold to use (default =
\code{1.0})}
}
\value{
A numeric value representing the time when MCC first reaches or
exceeds the \code{threshold}, or \code{NA_real_} if MCC never reaches \code{threshold}
during the observed follow-up period.
}
\description{
Helper function that identifies the first time point when the Mean Cumulative
Count (MCC) reaches or exceeds the threshold. An MCC value of the threshold
represents the time when the population experiences an average of
\verb{<threshold>} event(s).
}
\details{
The MCC represents the expected cumulative number of events per person
in the population initially at risk. When MCC = \code{threshold}, this indicates
that the population has experienced an average of 1 event per person. This
milestone can be useful for:
\itemize{
\item Identifying when the event burden reaches clinical or epidemiological
significance
\item Comparing event timing across different exposure groups or populations
\item Setting thresholds for intervention planning
}

Note that MCC values can exceed \code{threshold}, indicating more than \code{threshold}
number of events per person on average, which distinguishes it from
probability-based measures like cumulative incidence that are bounded
between 0 and 1.
}
\keyword{internal}
