% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/map_risk.R
\name{map_risk}
\alias{map_risk}
\title{Map pest risk}
\usage{
map_risk(
  t_vals = NULL,
  t_rast = NULL,
  region = NULL,
  res = 2.5,
  path = NULL,
  mask = TRUE,
  verbose = FALSE,
  plot = TRUE,
  interactive = FALSE
)
}
\arguments{
\item{t_vals}{a \code{data.frame} or \code{\link[dplyr:reexports]{dplyr::tibble()}} as produced by \code{\link[=therm_suit_bounds]{therm_suit_bounds()}}.
\code{t_vals} must contain results derived from a single model.
It must contain at least one row of numeric values.
Additionally, the minimum ("left") thermal boundary or \code{tval_left}
must be lower than the maximum ("right") one, or \code{tval_right} for all rows.
Nominative columns must be present in the input (i.e., \code{model_name},
\code{suitability}, \code{pred_suit} and \code{iter}).}

\item{t_rast}{Optional 12-layer \code{\link[terra:SpatRaster-class]{terra::SpatRaster()}} with monthly mean
temperatures for the region of interest. If not provided, global
WorldClim raster layers will be automatically (down)loaded
using \code{\link[geodata:worldclim]{geodata::worldclim_global()}}, and cropped to \code{region} (if provided).
Note that the download can be slow the first time you use the function in a new
\code{path}. If you get a download error, consider running e.g \code{options(timeout = 500)} (or more).}

\item{region}{Optional object specifying the region to map. Must overlap the
extent of \code{t_rast} if both are provided. Can be a \code{\link[terra:SpatVector-class]{terra::SpatVector()}}
polygon (obtained with \code{\link[terra:vect]{terra::vect()}}); or an \code{sf} polygon,
in which case it will be coerced with \code{\link[terra:vect]{terra::vect()}}) to a \code{\link[terra:SpatVector-class]{terra::SpatVector()}};
or a character vector of country
name(s) in English (see \link{country_names}), in which case climate maps will be
downloaded for those countries; or a \code{\link[terra:SpatExtent-class]{terra::SpatExtent()}} object (obtained with
\code{\link[terra:ext]{terra::ext()}}); or a numeric vector of length 4 specifying the region
coordinates as follows: \code{c(xmin, xmax, ymin, ymax)}. The latter two must be in
the same CRS as\code{t_rast} if \code{t_rast} is provided, or in unprojected lon-lat
coordinates (WGS84, EPSG:4326) otherwise. If NULL, the output maps will
cover the entire \code{t_rast} if provided, or the entire world otherwise.}

\item{res}{Argument to pass to \code{\link[geodata:worldclim]{geodata::worldclim_global()}} specifying
the spatial resolution for the raster maps to download, if \code{t_rast} is not
provided. The default is 2.5 arc-minutes. Beware that lower values (e.g., 0.5)
may lead to extremely heavy data sets and large computation times.}

\item{path}{Argument to pass to \code{\link[geodata:worldclim]{geodata::worldclim_global()}} (if \code{t_rast}
is not provided) and/or to \code{\link[geodata:world]{geodata::world()}} (if \code{region} is a vector of
country names) specifying the folder path for the downloaded maps.}

\item{mask}{Logical value to pass to \code{\link[terra:mask]{terra::mask()}} specifying whether the
output raster maps should be masked with the borders of the target 'region',
if this is a polygon map or a vector of country names. The default is TRUE.
If FALSE, the entire rectangular extent of 'region' will be used.}

\item{verbose}{Logical value specifying whether to display messages about
what the function is doing at possibly slow steps. The default is FALSE.
Setting it to TRUE can be useful for checking progress when maps are large.}

\item{plot}{Logical value specifying whether to plot the results in a map.
Defaults to TRUE. Note that the function will always return a \code{\link[terra:SpatRaster-class]{terra::SpatRaster()}}
object even if \code{plot = TRUE}.}

\item{interactive}{Logical value specifying whether the plotted map should be
interactive (if plot=TRUE). The default is TRUE if the 'leaflet' package is installed.}
}
\value{
This function returns a \code{\link[terra:SpatRaster-class]{terra::SpatRaster()}} with up to 2 layers:
the (\code{\link[=mean]{mean()}}) number of months with temperature within the species' thermal
bounds; and (if \code{t_vals} has >1 rows) the standard deviation (\code{\link[stats:sd]{stats::sd()}}) around
that mean.
}
\description{
This function produces a raster map where each pixel shows the number of
months per year in which temperature is within a given set of bounds. If
the input has several pairs of minimum and maximum temperatures (as
produced by \code{\link[=therm_suit_bounds]{therm_suit_bounds()}}), the output raster has two layers: mean
and standard deviation.
}
\examples{
\dontshow{if (interactive()) withAutoprint(\{ # examplesIf}
data("aphid")

fitted_tpcs <- fit_devmodels(temp = aphid$temperature,
                             dev_rate = aphid$rate_value,
                             model_name = "all")

plot_devmodels(temp = aphid$temperature,
               dev_rate = aphid$rate_value,
               fitted_parameters = fitted_tpcs,
               species = "Brachycaudus schwartzi",
               life_stage = "Nymphs")

boot_tpcs <- predict_curves(temp = aphid$temperature,
                            dev_rate = aphid$rate_value,
                            fitted_parameters = fitted_tpcs,
                            model_name_2boot = c("lactin2", "briere2", "beta"),
                            propagate_uncertainty = TRUE,
                            n_boots_samples = 10)

print(boot_tpcs)

plot_uncertainties(temp = aphid$temperature,
                   dev_rate = aphid$rate_value,
                   bootstrap_tpcs = boot_tpcs,
                   species = "Brachycaudus schwartzi",
                   life_stage = "Nymphs")


boundaries <- therm_suit_bounds(preds_tbl = boot_tpcs,
                                model_name = "lactin2",
                                suitability_threshold = 80)

risk_map_reunion <- map_risk(t_vals = boundaries,
                             path = tempdir(),
                             region = "Réunion",
                             mask = TRUE,
                             plot = TRUE,
                             interactive = FALSE,
                             verbose = TRUE)
\dontshow{\}) # examplesIf}
}
