% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/symtable.R
\name{symclear}
\alias{symclear}
\title{Clear the Macro Symbol Table}
\usage{
symclear(variables = TRUE, functions = TRUE)
}
\arguments{
\item{variables}{Whether or not to clear the macro symbol table.
Default is TRUE.}

\item{functions}{Whether or not to clear the macro function list.
Default is TRUE.}
}
\value{
The number of objects cleared, invisibly.  The function also
outputs a message saying how many objects were cleared.
}
\description{
The \code{symclear} function clears the macro symbol table of any
stored macro variables and macro functions.  The function is used
to avoid contamination between one call to \code{msource} and the
next.  It is called automatically when the "clear" parameter of
\code{msource} is set to TRUE.  If the "clear" parameter is
set to FALSE, you can clear the symbol table manually with
the \code{symclear} function.
}
\examples{
library(macro)

# Get path to demo macro program
src <- system.file("extdata/Demo4.R", package = "macro")

# Display source code
# - This is the macro input code
cd <- readLines(src)
cat(paste(cd, "\n"))
# #\% Create some macro variables
# #\%let x <- 1
# #\%let y <- 2
# #\%let z <- &x + &y
#
# #\% Create a macro function
# #\%macro test(vl = Hello!)
# print("&vl")
# #\%mend

# Execute source code
msource(src, echo = FALSE)

# View symbol table
symtable()
# # Macro Symbol Table: 3 macro variables
#   Name Value
# 1   &x     1
# 2   &y     2
# 3   &z 1 + 2
# # Macro Function List: 1 macro functions
#   Name Parameter Default
# 1 test        vl  Hello!

# Clear symbol table
symclear()
# Clearing macro symbol table...
# 4 items cleared.

# View symbol table again
symtable()
# # Macro Symbol Table: (empty)
# # Macro Function List: (empty)

}
\seealso{
\code{\link[=msource]{msource()}}

Other symtable: 
\code{\link{print.symtable}()},
\code{\link{symget}()},
\code{\link{symput}()},
\code{\link{symtable}()}
}
\concept{symtable}
