% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{nearest_cluster}
\alias{nearest_cluster}
\title{Allocates each rw (observation) in data to the nearest cluster centre.}
\usage{
nearest_cluster(data, centres)
}
\arguments{
\item{data}{a matrix (n x m) to be clustered}

\item{centres}{matrix of cluster means (k x m), where k is the number of clusters.}
}
\value{
vector of cluster allocations, n values ranging from 1 to k.
}
\description{
For each observation the euclidean distance to each of the cluster centres is calculated and cluster with the smallest distance is return for that observation.
}
\examples{
iris_mat <- as.matrix(iris[,1:4])
centres<- tkmeans(iris_mat, 3 , 0.2, c(1,1,1,1), 1, 10, 0.001)
nearest_cluster(iris_mat, centres)
}
